/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: stddef.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_STDDEF_H
#define __PALMSOURCE_CC_HDR_STDDEF_H


#ifdef __cplusplus
namespace std {
#endif

typedef signed int	ptrdiff_t;
typedef unsigned int	size_t;
#ifndef __cplusplus
typedef unsigned int	wchar_t;
#endif

#ifndef NULL
#define NULL	0
#endif

#ifndef offsetof
#define offsetof(Type, Member) ((size_t)__INTADDR__(&(((Type*)0)->Member)))
#endif

#ifdef __cplusplus
} /* namespace std */
#endif /* __cplusplus */

#endif /* __PALMSOURCE_CC_HDR_STDDEF_H */


#if defined(__cplusplus) && !defined(__PALMSOURCE_CC_HDR_STDDEF_H_NO_STD)
/* This block intentionally outside of header guards */
using std::ptrdiff_t;
using std::size_t;
#endif /* __cplusplus) && !__PALMSOURCE_CC_HDR_STDDEF_H_NO_STD */
